/*
 * Decompiled with CFR 0.152.
 */
package com.tino1b2be.cmdprograms;

import com.tino1b2be.audio.WavFileException;
import com.tino1b2be.cmdprograms.AudioTestResult;
import com.tino1b2be.cmdprograms.AudioTestThread;
import com.tino1b2be.dtmfdecoder.DTMFDecoderException;
import com.tino1b2be.dtmfdecoder.DTMFUtil;
import com.tino1b2be.dtmfdecoder.FileUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Scanner;

public class AudioRecordingsTest {
    private static String parent;
    private static String resultsFilename;

    public static void main(String[] args) throws IOException, WavFileException, InterruptedException, DTMFDecoderException {
        AudioTestThread[] testThreads;
        if (args.length == 3) {
            parent = args[0];
            resultsFilename = args[1];
            DTMFUtil.setMinToneDuration(Integer.parseInt(args[2]));
        } else {
            AudioRecordingsTest.getInputFromUser();
        }
        System.out.println("Tests now running. This may take a while please be patient.\nFiles are assumed to be MONO mp3 files or wav files");
        double startT = System.currentTimeMillis();
        ArrayList<ArrayList<File>> testThreadFiles = new ArrayList<ArrayList<File>>();
        ArrayList<File> testFiles = FileUtil.getFiles(parent, ".wav");
        AudioRecordingsTest.setUpThreadFiles(testThreadFiles, testFiles);
        AudioTestResult[] results = new AudioTestResult[testFiles.size()];
        for (AudioTestThread thread : testThreads = AudioRecordingsTest.startThreads(testThreadFiles, results)) {
            thread.join();
        }
        FileUtil.writeToFileSuccessOnly(results, resultsFilename);
        double perc = (double)AudioTestResult.filesWithTones.get() * 100.0 / (double)testFiles.size();
        System.out.println("Done!\nNumber of files analysed: " + results.length + "\nFiles with tones = " + AudioTestResult.filesWithTones.get() + " = " + perc + "% of all files.");
        double stopT = System.currentTimeMillis();
        System.out.println("Time taken = " + Double.toString((stopT - startT) / 1000.0) + "sec.");
    }

    private static AudioTestThread[] startThreads(ArrayList<ArrayList<File>> testThreadFiles, AudioTestResult[] results) {
        int i;
        AudioTestThread[] testThreads = new AudioTestThread[testThreadFiles.size()];
        int start = 0;
        int stop = 0;
        for (i = 0; i < testThreadFiles.size() - 1; ++i) {
            stop = start + testThreadFiles.get(i).size();
            testThreads[i] = new AudioTestThread(testThreadFiles.get(i), results, start);
            testThreads[i].start();
            start = stop;
        }
        testThreads[i] = new AudioTestThread(testThreadFiles.get(i), results, start);
        testThreads[i].run();
        return testThreads;
    }

    private static void setUpThreadFiles(ArrayList<ArrayList<File>> testThreadFiles, ArrayList<File> testFiles) {
        int index = 0;
        do {
            ArrayList<File> threadFiles = new ArrayList<File>();
            threadFiles.add(testFiles.get(index++));
            while (index % 1000 != 0 && index < testFiles.size()) {
                threadFiles.add(testFiles.get(index));
                ++index;
            }
            testThreadFiles.add(threadFiles);
        } while (index < testFiles.size());
    }

    private static void getInputFromUser() {
        System.out.print("Please enter the directory containing the test files: ");
        Scanner sc = new Scanner(System.in);
        parent = sc.nextLine();
        System.out.print("Please enter the minimum tone duration to be used for detection.: ");
        while (true) {
            try {
                double tone = Double.parseDouble(sc.nextLine());
                DTMFUtil.setMinToneDuration((int)tone);
            }
            catch (NumberFormatException e) {
                System.err.println("Input not a number. Please enter a valid number, decimals accepted. (0 or negative number to use default tone duration.)");
                continue;
            }
            catch (NullPointerException e) {
                System.err.println("Please enter a valid number, decimals accepted. (0 or negative number to use default tone duration.)");
                continue;
            }
            catch (DTMFDecoderException e) {
                System.err.println(e.getMessage());
                continue;
            }
            break;
        }
        System.out.print("Please enter the filename for the test results: ");
        resultsFilename = sc.nextLine();
        sc.close();
    }
}

